#!/bin/bash -l
#SBATCH --nodes=1
#SBATCH --ntasks-per-node=1
#SBATCH --cpus-per-task=4
#SBATCH --mem=1G
#SBATCH --time=24:00:00
#SBATCH --job-name=IndivQLearningContinuousGridworld
#SBATCH --partition=short
#SBATCH --output=/scratch/melcer.d/centralized_verification/out5
#SBATCH --array=0-239

sleep $[ ( $RANDOM % 10 )  + 1 ]s
cd ~/code/centralized_verification || exit
module load anaconda3
conda activate centralized_verification
CSV_NAME="ContinuousGridworldTrain"
mkdir "/scratch/melcer.d/centralized_verification/output/$CSV_NAME"
OUTPUT_FILE=/scratch/melcer.d/centralized_verification/output/$CSV_NAME/$SLURM_ARRAY_TASK_ID.out
PYTHONPATH=. python experiments/parallel/q_learning_1.py --node-idx $SLURM_ARRAY_TASK_ID --threads-per-node 1 parallel_configs/$CSV_NAME.csv > "$OUTPUT_FILE" 2>&1